/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouch.h"

#include "EventTarget.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventTarget.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsTouchClientX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchClientY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchScreenX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchScreenY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchPageX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchPageY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchIdentifier(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitRadiusX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitRadiusY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitRotationAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchWebkitForce(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTouchConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTouchPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTouchPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTouchPrototype* ptr = new (NotNull, JSC::allocateCell<JSTouchPrototype>(vm.heap)) JSTouchPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTouchPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTouch> JSTouchConstructor;

/* Hash table */

static const struct CompactHashIndex JSTouchTableIndex[33] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 5, -1 },
    { 10, -1 },
    { -1, -1 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 1, 32 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 7, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { 6, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { 9, -1 },
    { 3, -1 },
    { 11, -1 },
    { 8, -1 },
};


static const HashTableValue JSTouchTableValues[] =
{
    { "clientX", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientY", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "screenX", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "screenY", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pageX", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pageY", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "target", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "identifier", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitRadiusX", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRadiusX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitRadiusY", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRadiusY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitRotationAngle", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRotationAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitForce", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitForce), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSTouchTable = { 12, 31, true, JSTouchTableValues, JSTouchTableIndex };
template<> JSValue JSTouchConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTouchConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTouch::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Touch"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTouchConstructor::s_info = { "Touch", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTouchConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTouchPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTouchConstructor) } },
};

const ClassInfo JSTouchPrototype::s_info = { "TouchPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTouchPrototype) };

void JSTouchPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTouchPrototypeTableValues, *this);
}

const ClassInfo JSTouch::s_info = { "Touch", &Base::s_info, &JSTouchTable, CREATE_METHOD_TABLE(JSTouch) };

JSTouch::JSTouch(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Touch>&& impl)
    : JSDOMWrapper<Touch>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTouch::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTouchPrototype::create(vm, globalObject, JSTouchPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTouch::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouch>(vm, globalObject);
}

void JSTouch::destroy(JSC::JSCell* cell)
{
    JSTouch* thisObject = static_cast<JSTouch*>(cell);
    thisObject->JSTouch::~JSTouch();
}

bool JSTouch::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSTouch*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSTouch, Base>(state, JSTouchTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsTouchClientX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "clientX");
        reportDeprecatedGetterError(*state, "Touch", "clientX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.clientX());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchClientY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "clientY");
        reportDeprecatedGetterError(*state, "Touch", "clientY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.clientY());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchScreenX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "screenX");
        reportDeprecatedGetterError(*state, "Touch", "screenX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.screenX());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchScreenY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "screenY");
        reportDeprecatedGetterError(*state, "Touch", "screenY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.screenY());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchPageX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "pageX");
        reportDeprecatedGetterError(*state, "Touch", "pageX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.pageX());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchPageY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "pageY");
        reportDeprecatedGetterError(*state, "Touch", "pageY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.pageY());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "target");
        reportDeprecatedGetterError(*state, "Touch", "target");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.target()));
    return JSValue::encode(result);
}


EncodedJSValue jsTouchIdentifier(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "identifier");
        reportDeprecatedGetterError(*state, "Touch", "identifier");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.identifier());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchWebkitRadiusX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "webkitRadiusX");
        reportDeprecatedGetterError(*state, "Touch", "webkitRadiusX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitRadiusX());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchWebkitRadiusY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "webkitRadiusY");
        reportDeprecatedGetterError(*state, "Touch", "webkitRadiusY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitRadiusY());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchWebkitRotationAngle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "webkitRotationAngle");
        reportDeprecatedGetterError(*state, "Touch", "webkitRotationAngle");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitRotationAngle());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchWebkitForce(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouch*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouch*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "Touch", "webkitForce");
        reportDeprecatedGetterError(*state, "Touch", "webkitForce");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitForce());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTouchPrototype* domObject = jsDynamicCast<JSTouchPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTouch::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTouchConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTouchPrototype* domObject = jsDynamicCast<JSTouchPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSTouch::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSTouchOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTouchOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTouch = jsCast<JSTouch*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTouch->wrapped(), jsTouch);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Touch* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTouch>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Touch* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTouch>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Touch.
    COMPILE_ASSERT(!__is_polymorphic(Touch), Touch_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSTouch>(globalObject, impl);
}

Touch* JSTouch::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTouch*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(TOUCH_EVENTS)
