/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTreeWalker.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionParentNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionFirstChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionLastChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionPreviousSibling(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionNextSibling(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionPreviousNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionNextNode(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTreeWalkerRoot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTreeWalkerWhatToShow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTreeWalkerFilter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTreeWalkerCurrentNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTreeWalkerCurrentNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTreeWalkerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTreeWalkerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTreeWalkerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTreeWalkerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTreeWalkerPrototype* ptr = new (NotNull, JSC::allocateCell<JSTreeWalkerPrototype>(vm.heap)) JSTreeWalkerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTreeWalkerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTreeWalker> JSTreeWalkerConstructor;

template<> JSValue JSTreeWalkerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTreeWalkerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTreeWalker::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TreeWalker"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTreeWalkerConstructor::s_info = { "TreeWalker", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTreeWalkerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTreeWalkerPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTreeWalkerConstructor) } },
    { "root", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "whatToShow", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerWhatToShow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "filter", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerFilter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentNode", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTreeWalkerCurrentNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTreeWalkerCurrentNode) } },
    { "parentNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionParentNode), (intptr_t) (0) } },
    { "firstChild", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionFirstChild), (intptr_t) (0) } },
    { "lastChild", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionLastChild), (intptr_t) (0) } },
    { "previousSibling", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionPreviousSibling), (intptr_t) (0) } },
    { "nextSibling", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionNextSibling), (intptr_t) (0) } },
    { "previousNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionPreviousNode), (intptr_t) (0) } },
    { "nextNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTreeWalkerPrototypeFunctionNextNode), (intptr_t) (0) } },
};

const ClassInfo JSTreeWalkerPrototype::s_info = { "TreeWalkerPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTreeWalkerPrototype) };

void JSTreeWalkerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTreeWalkerPrototypeTableValues, *this);
}

const ClassInfo JSTreeWalker::s_info = { "TreeWalker", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTreeWalker) };

JSTreeWalker::JSTreeWalker(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TreeWalker>&& impl)
    : JSDOMWrapper<TreeWalker>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTreeWalker::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTreeWalkerPrototype::create(vm, globalObject, JSTreeWalkerPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTreeWalker::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTreeWalker>(vm, globalObject);
}

void JSTreeWalker::destroy(JSC::JSCell* cell)
{
    JSTreeWalker* thisObject = static_cast<JSTreeWalker*>(cell);
    thisObject->JSTreeWalker::~JSTreeWalker();
}

EncodedJSValue jsTreeWalkerRoot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTreeWalker*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TreeWalker", "root");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.root()));
    return JSValue::encode(result);
}


EncodedJSValue jsTreeWalkerWhatToShow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTreeWalker*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TreeWalker", "whatToShow");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.whatToShow());
    return JSValue::encode(result);
}


EncodedJSValue jsTreeWalkerFilter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTreeWalker*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TreeWalker", "filter");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.filter()));
    return JSValue::encode(result);
}


EncodedJSValue jsTreeWalkerCurrentNode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTreeWalker*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TreeWalker", "currentNode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.currentNode()));
    return JSValue::encode(result);
}


EncodedJSValue jsTreeWalkerConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTreeWalkerPrototype* domObject = jsDynamicCast<JSTreeWalkerPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTreeWalker::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTreeWalkerConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTreeWalkerPrototype* domObject = jsDynamicCast<JSTreeWalkerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSTreeWalkerCurrentNode(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSTreeWalker* castedThis = jsDynamicCast<JSTreeWalker*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "TreeWalker", "currentNode");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* nativeValue = JSNode::toWrapped(value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCurrentNode(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSTreeWalker::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTreeWalkerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionParentNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "parentNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentNode()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionFirstChild(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "firstChild");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.firstChild()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionLastChild(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "lastChild");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.lastChild()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionPreviousSibling(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "previousSibling");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousSibling()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionNextSibling(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "nextSibling");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextSibling()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionPreviousNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "previousNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousNode()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTreeWalkerPrototypeFunctionNextNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTreeWalker*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TreeWalker", "nextNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTreeWalker::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextNode()));
    return JSValue::encode(result);
}

void JSTreeWalker::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSTreeWalker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSTreeWalkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTreeWalkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTreeWalker = jsCast<JSTreeWalker*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTreeWalker->wrapped(), jsTreeWalker);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, TreeWalker* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTreeWalker>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, TreeWalker* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTreeWalker>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TreeWalker.
    COMPILE_ASSERT(!__is_polymorphic(TreeWalker), TreeWalker_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSTreeWalker>(globalObject, impl);
}

TreeWalker* JSTreeWalker::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTreeWalker*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
