/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVTTRegion.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSTextTrack.h"
#include "TextTrack.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsVTTRegionTrack(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsVTTRegionId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionId(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionRegionAnchorX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionRegionAnchorX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionRegionAnchorY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionRegionAnchorY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionViewportAnchorX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionViewportAnchorX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionViewportAnchorY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionViewportAnchorY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionScroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionScroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsVTTRegionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSVTTRegionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSVTTRegionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSVTTRegionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVTTRegionPrototype* ptr = new (NotNull, JSC::allocateCell<JSVTTRegionPrototype>(vm.heap)) JSVTTRegionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVTTRegionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSVTTRegion> JSVTTRegionConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSVTTRegionConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSVTTRegionConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "VTTRegion");
    RefPtr<VTTRegion> object = VTTRegion::create(*context);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSVTTRegionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVTTRegionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSVTTRegion::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("VTTRegion"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSVTTRegionConstructor::s_info = { "VTTRegion", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVTTRegionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSVTTRegionPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionConstructor) } },
    { "track", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionTrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionId) } },
    { "width", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionWidth) } },
    { "height", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionHeight) } },
    { "regionAnchorX", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionRegionAnchorX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionRegionAnchorX) } },
    { "regionAnchorY", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionRegionAnchorY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionRegionAnchorY) } },
    { "viewportAnchorX", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionViewportAnchorX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionViewportAnchorX) } },
    { "viewportAnchorY", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionViewportAnchorY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionViewportAnchorY) } },
    { "scroll", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVTTRegionScroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSVTTRegionScroll) } },
};

const ClassInfo JSVTTRegionPrototype::s_info = { "VTTRegionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVTTRegionPrototype) };

void JSVTTRegionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVTTRegionPrototypeTableValues, *this);
}

const ClassInfo JSVTTRegion::s_info = { "VTTRegion", &Base::s_info, 0, CREATE_METHOD_TABLE(JSVTTRegion) };

JSVTTRegion::JSVTTRegion(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VTTRegion>&& impl)
    : JSDOMWrapper<VTTRegion>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSVTTRegion::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSVTTRegionPrototype::create(vm, globalObject, JSVTTRegionPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSVTTRegion::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSVTTRegion>(vm, globalObject);
}

void JSVTTRegion::destroy(JSC::JSCell* cell)
{
    JSVTTRegion* thisObject = static_cast<JSVTTRegion*>(cell);
    thisObject->JSVTTRegion::~JSVTTRegion();
}

EncodedJSValue jsVTTRegionTrack(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "track");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.track()));
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "id");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.id());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.width());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.height());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionRegionAnchorX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "regionAnchorX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.regionAnchorX());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionRegionAnchorY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "regionAnchorY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.regionAnchorY());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionViewportAnchorX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "viewportAnchorX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.viewportAnchorX());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionViewportAnchorY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "viewportAnchorY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.viewportAnchorY());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionScroll(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSVTTRegion*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "VTTRegion", "scroll");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.scroll());
    return JSValue::encode(result);
}


EncodedJSValue jsVTTRegionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSVTTRegionPrototype* domObject = jsDynamicCast<JSVTTRegionPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSVTTRegion::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSVTTRegionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSVTTRegionPrototype* domObject = jsDynamicCast<JSVTTRegionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSVTTRegionId(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "id");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setId(nativeValue);
}


void setJSVTTRegionWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "width");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWidth(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTRegionHeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "height");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHeight(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTRegionRegionAnchorX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "regionAnchorX");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setRegionAnchorX(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTRegionRegionAnchorY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "regionAnchorY");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setRegionAnchorY(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTRegionViewportAnchorX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "viewportAnchorX");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setViewportAnchorX(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTRegionViewportAnchorY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "viewportAnchorY");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setViewportAnchorY(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSVTTRegionScroll(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSVTTRegion* castedThis = jsDynamicCast<JSVTTRegion*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "VTTRegion", "scroll");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setScroll(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSVTTRegion::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVTTRegionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSVTTRegionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSVTTRegionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVTTRegion = jsCast<JSVTTRegion*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVTTRegion->wrapped(), jsVTTRegion);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VTTRegion@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9VTTRegionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, VTTRegion* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSVTTRegion>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, VTTRegion* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSVTTRegion>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7VTTRegion@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9VTTRegionE[2];
#if COMPILER(CLANG)
    // If this fails VTTRegion does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(VTTRegion), VTTRegion_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // VTTRegion has subclasses. If VTTRegion has subclasses that get passed
    // to toJS() we currently require VTTRegion you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSVTTRegion>(globalObject, impl);
}

VTTRegion* JSVTTRegion::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVTTRegion*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
