/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugShaders.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSWebGLShader.h"
#include "URL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource(JSC::ExecState*);

class JSWebGLDebugShadersPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLDebugShadersPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDebugShadersPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDebugShadersPrototype>(vm.heap)) JSWebGLDebugShadersPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDebugShadersPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugShadersPrototypeTableValues[] =
{
    { "getTranslatedShaderSource", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource), (intptr_t) (1) } },
};

const ClassInfo JSWebGLDebugShadersPrototype::s_info = { "WebGLDebugShadersPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDebugShadersPrototype) };

void JSWebGLDebugShadersPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDebugShadersPrototypeTableValues, *this);
}

const ClassInfo JSWebGLDebugShaders::s_info = { "WebGLDebugShaders", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDebugShaders) };

JSWebGLDebugShaders::JSWebGLDebugShaders(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDebugShaders>&& impl)
    : JSDOMWrapper<WebGLDebugShaders>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLDebugShaders::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLDebugShadersPrototype::create(vm, globalObject, JSWebGLDebugShadersPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLDebugShaders::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLDebugShaders>(vm, globalObject);
}

void JSWebGLDebugShaders::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugShaders* thisObject = static_cast<JSWebGLDebugShaders*>(cell);
    thisObject->JSWebGLDebugShaders::~JSWebGLDebugShaders();
}

EncodedJSValue JSC_HOST_CALL jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebGLDebugShaders*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebGLDebugShaders", "getTranslatedShaderSource");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebGLDebugShaders::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSWebGLShader::info()))
        return throwArgumentTypeError(*state, 0, "shader", "WebGLDebugShaders", "getTranslatedShaderSource", "WebGLShader");
    WebGLShader* shader = JSWebGLShader::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getTranslatedShaderSource(shader, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSWebGLDebugShadersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLDebugShaders = jsCast<JSWebGLDebugShaders*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDebugShaders->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDebugShadersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDebugShaders = jsCast<JSWebGLDebugShaders*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDebugShaders->wrapped(), jsWebGLDebugShaders);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDebugShaders@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17WebGLDebugShadersE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDebugShaders* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLDebugShaders>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDebugShaders* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLDebugShaders>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLDebugShaders@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17WebGLDebugShadersE[2];
#if COMPILER(CLANG)
    // If this fails WebGLDebugShaders does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLDebugShaders), WebGLDebugShaders_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLDebugShaders has subclasses. If WebGLDebugShaders has subclasses that get passed
    // to toJS() we currently require WebGLDebugShaders you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLDebugShaders>(globalObject, impl);
}

WebGLDebugShaders* JSWebGLDebugShaders::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDebugShaders*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
