/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestProgressEvent.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestProgressEventPosition(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestProgressEventTotalSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestProgressEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestProgressEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLHttpRequestProgressEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXMLHttpRequestProgressEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestProgressEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestProgressEventPrototype>(vm.heap)) JSXMLHttpRequestProgressEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestProgressEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSXMLHttpRequestProgressEvent> JSXMLHttpRequestProgressEventConstructor;

template<> JSValue JSXMLHttpRequestProgressEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSProgressEvent::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestProgressEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestProgressEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XMLHttpRequestProgressEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXMLHttpRequestProgressEventConstructor::s_info = { "XMLHttpRequestProgressEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestProgressEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestProgressEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestProgressEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestProgressEventConstructor) } },
    { "position", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestProgressEventPosition), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "totalSize", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestProgressEventTotalSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSXMLHttpRequestProgressEventPrototype::s_info = { "XMLHttpRequestProgressEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestProgressEventPrototype) };

void JSXMLHttpRequestProgressEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestProgressEventPrototypeTableValues, *this);
}

const ClassInfo JSXMLHttpRequestProgressEvent::s_info = { "XMLHttpRequestProgressEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestProgressEvent) };

JSXMLHttpRequestProgressEvent::JSXMLHttpRequestProgressEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestProgressEvent>&& impl)
    : JSProgressEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXMLHttpRequestProgressEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXMLHttpRequestProgressEventPrototype::create(vm, globalObject, JSXMLHttpRequestProgressEventPrototype::createStructure(vm, globalObject, JSProgressEvent::getPrototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequestProgressEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestProgressEvent>(vm, globalObject);
}

EncodedJSValue jsXMLHttpRequestProgressEventPosition(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestProgressEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestProgressEvent", "position");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.position());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestProgressEventTotalSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestProgressEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestProgressEvent", "totalSize");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.totalSize());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestProgressEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXMLHttpRequestProgressEventPrototype* domObject = jsDynamicCast<JSXMLHttpRequestProgressEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXMLHttpRequestProgressEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXMLHttpRequestProgressEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXMLHttpRequestProgressEventPrototype* domObject = jsDynamicCast<JSXMLHttpRequestProgressEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXMLHttpRequestProgressEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestProgressEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
